%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%     Symbolic Laplacian in spherical coordinates


% This function computes div(grad(f)) in Spherical coordinate system and
% returns symbolic expression

function F = LaplaceSph(f)
syms r phi theta

Fr = diff(r^2*diff(f,r),r);
Fp = diff(f,phi,2);
Ft = diff(sin(theta)*diff(f,theta),theta);
F = 1/r^2*Fr + 1/(r*sin(theta))^2*Fp + 1/(r^2*sin(theta))*Ft;